/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.compactmods.crafting.core.CCBlocks;
import dev.compactmods.crafting.core.CCItems;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class LootTableGenerator
extends LootTableProvider {
    public LootTableGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    private static class Blocks
    extends BlockLoot {
        private Blocks() {
        }

        protected void addTables() {
            this.registerSelfDroppedBlock(CCBlocks.FIELD_PROJECTOR_BLOCK, CCItems.FIELD_PROJECTOR_ITEM);
            this.registerSelfDroppedBlock(CCBlocks.MATCH_FIELD_PROXY_BLOCK, CCItems.MATCH_PROXY_ITEM);
            this.registerSelfDroppedBlock(CCBlocks.RESCAN_FIELD_PROXY_BLOCK, CCItems.RESCAN_PROXY_ITEM);
        }

        private LootPool.Builder registerSelfDroppedBlock(RegistryObject<Block> block, RegistryObject<Item> item) {
            LootPool.Builder builder = LootPool.m_79043_().name(((Block)block.get()).getRegistryName().toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)item.get())));
            this.m_124165_((Block)block.get(), LootTable.m_79147_().m_79161_(builder));
            return builder;
        }

        protected Iterable<Block> getKnownBlocks() {
            return ImmutableList.of((Object)((Block)CCBlocks.FIELD_PROJECTOR_BLOCK.get()), (Object)((Block)CCBlocks.MATCH_FIELD_PROXY_BLOCK.get()), (Object)((Block)CCBlocks.RESCAN_FIELD_PROXY_BLOCK.get()));
        }
    }
}

